#include "derivative.h" /* include peripheral declarations */


/**************************************************************
Define Prototypes
**************************************************************/

void calc_xy(void);

word Get_Point(char,char);

void median (word *,char);

void ts_calibrate (char);

void DelayUsec(word usec);


/**************************************************************
Define GPIO Pins needed for A/D readings
   These pins are inputs or outputs driven high and/or low to put voltage across
   the touchscreen.  
**************************************************************/

#define XP             PTBDD_PTBDD3  //Pin 9 
#define XN             PTBDD_PTBDD2  //Pin 10 
#define YP             PTBDD_PTBDD5  //Pin 7 
#define YN             PTBDD_PTBDD4  //Pin 8 

#define XP_drive       PTBD_PTBD3    
#define XN_drive       PTBD_PTBD2     
#define YP_drive       PTBD_PTBD5     
#define YN_drive       PTBD_PTBD4    

#define Input    0       // Setting a PTBDD bit to 0 makes the pin an input
#define Output   1       // Setting a PTBDD bit to 1 makes the pin an output
#define VDD      1       // Setting a PTBD bit to 1 drives an output to VDD
#define GND      0       // Setting a PTBD bit to 0 drives an output to Ground

/**************************************************************
Define A/D Parameters
   These constants define values for the registers that control
   the A/D readings.  Table 9-1 of the MC9S08QG data sheet show
   the relationship between these values and the port pins that
   are converted.
**************************************************************/

#define AtoD_Convert     ADCSC1_ADCH  //The A/D register that gets set to turn the conversion
                                      //ON for a particular channel or to turn conversion Off.
#define XP_SNS           3            //Convert on PTA3/ADP3, pin 13
#define XN_SNS           1            //Convert on PTA1/ADP1, pin 15
#define YP_SNS           2            //Convert on PTA2/ADP2, pin 14
#define YN_SNS           0            //Convert on PTA0/ADP0, pin 16
#define AtoD_Off         31           //Turn A/D module Off

#define read_xcoor       1
#define read_ycoor       2
#define read_xmax        3
#define read_xmin        4
#define read_ymax        5
#define read_ymin        6

/**************************************************************
Define De-bounce Parameters.
   These constants define values for debouncing the XP pin when
   it is set up as an input.  This will be used to detect if a
   press is present or not.  XP_debounce will be used as a counter
   to debounce YP.  
**************************************************************/

#define XP_Input         PTBD_PTBD3    // Same a 'XP_drive'.  Used to sense the value of XP when an input.
#define Yes              1
#define No               0




extern word xdisplay;
extern word ydisplay;
extern word xmeas;
extern word ymeas;


